---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
aliases:
  - Symmetry
  - Asymmetry
---

# Symmetry : Asymmetry (relation)

> Invariance vs directed bias across interactions; relates to φ and closure geometry.

---

## Definition

- Balance/bias pattern
- Even/uneven relation
- Same/different rule
- Equal/directed flow

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Balance check | State even | `Monitor`, `Even` |
| Same test | Form match | `Check`, `Same` |
| Equal flow | Path fair | `Test`, `Equal` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Balance check | Feels fair | "Even sides" |
| Same test | Looks same | "Both ways" |
| Equal flow | Moves fair | "Fair share" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| State even | Feels fair | How balance works |
| Form match | Looks same | How same flows |
| Path fair | Moves fair | How equal forms |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Force even | Energy fair |
| Networks | Link same | Node fair |
| Cognition | Mind fair | Think even |
| Systems | Flow same | Move fair |

---

## Scale Effects

How Symmetry manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum fair | Wave even |
| λV | Gate same | State fair |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase even | Pattern fair |
| ∇S | Structure same | Clear even |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Wave fair | Light even |
| λV | Field same | Space fair |

Note: At extreme scales, symmetry faces fundamental limits (e.g., quantum fairness at ε, causal evenness at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: fair precision
- c: even speed
- ψA: phase same
- λV: gate fair

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Pattern fair | Wave even |
| Human | λV | Gate same | Flow fair |
| Cosmic | ψA | Phase even | Field same |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Lost fair | Pattern bias | Not even |
| Human | Bad same | Flow tilt | Unfair |
| Cosmic | Even fail | Field bias | Not same |

---

## Diagnostic Checklist

Technical tests:
- [ ] Even checked
- [ ] Same proven
- [ ] Fair shown
- [ ] Equal works

Humane tests:
- [ ] Feels fair
- [ ] Looks same
- [ ] Moves even
- [ ] Shares well

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical symmetry nor experiential fairness alone captures its full meaning.

---

## See Also

- [[Equivalence : Isomorphism (relation)]]
- [[Compatibility : Conflict (relation)]]
- [[Bridge : Articulation (relation)]]
- [[Form]]
- [[Field]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented